use [master]  
GO

create Database [CommonDB]
GO

USE [CommonDB]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[tSamples_Aeros](
	[Sample_Id] [varchar](50) NULL,
	[Sample_Name] [varchar](50) NULL,
	[WhiteData] [varchar](1000) NULL,
	[Sensor_SNo] [varchar](50) NULL,
	[Sensor_Name] [varchar](50) NULL,
	[Sensor_Mode] [varchar](50) NULL,
	[CreatedTime] [bigint] NULL,
	[SampleHeight] [varchar](50) NULL,
	[Distance]  [varchar](50) NULL,
	[MeasureInterval] [int] NULL,
	[RotationStatus]  [int] NULL,	
	[UserName] [varchar](50) NULL,
	[Application] [varchar](50) NULL
	
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[tStandards_Aeros](
	[Standard_Id] [varchar](50) NULL,
	[Standard_Name] [varchar](50) NULL,
	[WhiteData] [varchar](1000) NULL,
	[Sensor_SNo] [varchar](50) NULL,
	[Sensor_Name] [varchar](50) NULL,
	[Sensor_Mode] [varchar](50) NULL,
	[CreatedTime] [bigint] NULL,
	[SampleHeight] [varchar](50) NULL,
	[Distance]  [varchar](50) NULL,
	[MeasureInterval] [int] NULL,
	[RotationStatus]  [int] NULL,
	[UserName] [varchar](50) NULL,
	[Application] [varchar](50) NULL
	
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [dbo].[tblMeasurements_Aeros](
	[txtMeasurementID] [varchar](50) NULL,
	[txtMeasurementName] [varchar](50) NULL,
	[txtMeasurementType] [varchar](50) NULL,
	[blnIsNumeric] [numeric](1, 0) NULL,
	[txtScaleType] [varchar](50) NULL,
	[txtIlluminantOrObservers] [varchar](50) NULL,
	[dblValue1] [decimal](10, 6) NULL,
	[dblValue2] [decimal](10, 6) NULL,
	[dblValue3] [decimal](10, 6) NULL,
	[txtSensorID] [varchar](50) NULL,
	[txtSensorName] [varchar](50) NULL,
	[dtCreationTime] [varchar](50) NULL,
	[txtProductID] [varchar](50) NULL,
	[txtExtraID] [varchar](50) NULL,
	[WL400] [real] NULL,
	[WL410] [real] NULL,
	[WL420] [real] NULL,
	[WL430] [real] NULL,
	[WL440] [real] NULL,
	[WL450] [real] NULL,
	[WL460] [real] NULL,
	[WL470] [real] NULL,
	[WL480] [real] NULL,
	[WL490] [real] NULL,
	[WL500] [real] NULL,
	[WL510] [real] NULL,
	[WL520] [real] NULL,
	[WL530] [real] NULL,
	[WL540] [real] NULL,
	[WL550] [real] NULL,
	[WL560] [real] NULL,
	[WL570] [real] NULL,
	[WL580] [real] NULL,
	[WL590] [real] NULL,
	[WL600] [real] NULL,
	[WL610] [real] NULL,
	[WL620] [real] NULL,
	[WL630] [real] NULL,
	[WL640] [real] NULL,
	[WL650] [real] NULL,
	[WL660] [real] NULL,
	[WL670] [real] NULL,
	[WL680] [real] NULL,
	[WL690] [real] NULL,
	[WL700] [real] NULL,
	[SampleHeight] [varchar](50) NULL,
	[Distance]  [varchar](50) NULL,
	[MeasureInterval] [int] NULL,
	[RotationStatus]  [int] NULL,
	[UserName] [varchar](50) NULL,
	[Application] [varchar](50) NULL
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

